<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCustomerIdColToCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupons', function (Blueprint $table) {

            if (!Schema::hasColumn('coupons', 'created_by')) {
                $table->string('created_by', 50)->nullable()->default('admin');
            }

            if (!Schema::hasColumn('coupons', 'customer_id')) {
                $table->string('customer_id')->nullable()->default(json_encode(['all']));
            }

            if (!Schema::hasColumn('coupons', 'slug')) {
                $table->string('slug', 255)->nullable();
            }

            if (!Schema::hasColumn('coupons', 'restaurant_id')) {
                $table->foreignId('restaurant_id')->nullable();
            }
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn('created_by');
            $table->dropColumn('slug');
            $table->dropColumn('customer_id');
            $table->dropColumn('restaurant_id');
        });
    }
}
